IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_PROD_PRECO_ALT]'))
DROP VIEW [DBO].[V_EST_PROD_PRECO_ALT]
GO  
-- SELECT * FROM V_EST_PROD_PRECO_ALT WHERE CD_EMP = 1 AND CD_PROD = 59075
CREATE VIEW V_EST_PROD_PRECO_ALT AS
SELECT       
	EST_PROD_PRECO_ALT.CD_EMP,
	EST_PROD_PRECO_ALT_CPL.CD_PROD, 
	EST_PROD_PRECO_ALT.CD_ALT_PRECO, 
	EST_PROD_PRECO_ALT.DS_ALT_PRECO, 
	EST_PROD_PRECO_ALT.DT_CAD, 
	EST_PROD_PRECO_ALT.DT_APLICACAO, 
	EST_PROD_PRECO_ALT_CPL.VLR_TABELA, 
	EST_PROD_PRECO_ALT_CPL.VLR_OFERTA, 
	0 AS PERC_ICMS, 
	0 AS PERC_ICMS_GRUPO,
	CASE WHEN EST_PROD_PRECO_ALT.APLICADO = 0 THEN
		'NAO PROCESSADO'
	ELSE
		'PROCESSADO'
	END AS STATUS_PROCESSO, 
	GLB_USU.NM_USU,
	CASE WHEN TP_ALT_PRECO = 0 THEN 
		'PRECIFICACAO'
	ELSE
		'ALTERACAO PRECO DE OFERTA'
	END AS TIPO_ALTERACAO
FROM          
	EST_PROD_PRECO_ALT INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
	EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
    EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
	INNER JOIN GLB_USU ON 
	EST_PROD_PRECO_ALT.CD_USU = GLB_USU.CD_USU
UNION ALL
SELECT      
 	EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP,
	EST_PROD_PRECO_TBL_HIST_CPL.CD_PROD, 
	EST_PROD_PRECO_TBL_HIST.CD_CTR, 
	'IMPORTACAO DE ARQUIVO PMC' AS DS_ALT_PRECO, 
	EST_PROD_PRECO_TBL_HIST.DT_CAD, 
    EST_PROD_PRECO_TBL_HIST.DT_PROCESSAR, 
	EST_PROD_PRECO_TBL_HIST_CPL.VLR_VD, 
	0 AS VLR_OFERTA,
	EST_PROD_PRECO_TBL_HIST_CPL.PERC_ICMS, 
	EST_PROD_PRECO_TBL_GRUPO.PERC_ICMS AS PERC_ICMS_GRUPO,
	CASE WHEN EST_PROD_PRECO_TBL_HIST.FLAG_PROCESSADO = 0 THEN
		'NAO PROCESSADO'
     WHEN EST_PROD_PRECO_TBL_HIST.FLAG_PROCESSADO = 2 THEN
		'EM PROCESSAMENTO'  
	WHEN EST_PROD_PRECO_TBL_HIST.FLAG_PROCESSADO = 3 THEN
		'AGUARDANDO AGENDAMENTO'
     else 'PROCESSADO'
	END AS STATUS_PROCESSO, 
    GLB_USU.NM_USU,
	'PMC - ABCFARMA'
FROM            
	GLB_USU INNER JOIN EST_PROD_PRECO_TBL_HIST ON 
	GLB_USU.CD_USU = EST_PROD_PRECO_TBL_HIST.CD_USU 
	INNER JOIN EST_PROD_PRECO_TBL_HIST_CPL ON 
	EST_PROD_PRECO_TBL_HIST.CD_EMP = EST_PROD_PRECO_TBL_HIST_CPL.CD_EMP AND 
    EST_PROD_PRECO_TBL_HIST.CD_CTR = EST_PROD_PRECO_TBL_HIST_CPL.CD_CTR
	INNER JOIN EST_PROD_PRECO_TBL_GRUPO ON
	EST_PROD_PRECO_TBL_HIST.CD_CTR_GRP  = EST_PROD_PRECO_TBL_GRUPO.CD_CTR_GRP